/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.pi;

import com.ibm.hsc.cim.provider.pi.PIHscProviderUtils;
import com.ibm.hsc.cim.provider.pi.PIPartitionInstProvUtils;
import com.ibm.hsc.cim.provider.pi.PISysProfileUtils;
import com.ibm.hsc.cim.provider.pi.PISystemProfUpdater;
import com.ibm.hsc.cim.provider.rs6k.CimomWrapper;
import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.fsp.cmdhelpers.FspCmdHelper;
import com.ibm.hsc.fsp.cmdhelpers.FspISeriesPerfRanges;
import com.ibm.hsc.fsp.cmdhelpers.FspRequiredMemoryInfo;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import com.ibm.hsc.objmgr.lpar.OmLparMgr;
import com.ibm.hsc.objmgr.nvram.PIHMCSaveArea;
import com.ibm.hsc.rep.RObject;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;
import org.snia.wbem.client.CIMOMHandle;
import org.snia.wbem.client.ProviderCIMOMHandle;

public class PILPARProfileInstProvUtils {
    public static void checkTaskPrereqs(CIMObjectPath cIMObjectPath, ProviderCIMOMHandle providerCIMOMHandle, String string, OmCecMgr omCecMgr, PIHMCSaveArea pIHMCSaveArea, boolean bl) throws PIHscServerException, PIHscCmdMgrException {
        int n;
        int n2;
        System.out.println("Entering PILPARProfileInstProvUtils.checkTaskPrereqs");
        CIMInstance cIMInstance = null;
        String string2 = "";
        String string3 = "";
        try {
            cIMInstance = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, providerCIMOMHandle.getClass(cIMObjectPath, false), false);
            string2 = (String)cIMInstance.getProperty("UserDefinedName").getValue().getValue();
            string3 = (String)cIMInstance.getProperty("SettingID").getValue().getValue();
            n2 = omCecMgr.getCecState();
        }
        catch (CIMException cIMException) {
            throw new PIHscServerException("1585", cIMException);
        }
        if (n2 != 1 && n2 != 17) {
            throw new PIHscServerException("05E8", new String[]{string2, PIHscProviderUtils.mapStateStr(n2)}, null);
        }
        if (!bl) {
            n = PIPartitionInstProvUtils.getIntPartId(string);
            System.out.println("prof2:  partID = " + n);
            Hashtable hashtable = pIHMCSaveArea.getDefaultLPARProfile(n);
            if (hashtable != null) {
                System.out.println("prof2:  defProfProps = " + hashtable);
                int n3 = ((UnsignedInt16)hashtable.get("SettingID")).intValue();
                int n4 = Integer.parseInt(string3);
                if (n4 == n3) {
                    throw new PIHscServerException("07D2", null);
                }
            }
        }
        if (!bl && PILPARProfileInstProvUtils.theActiveProfile(providerCIMOMHandle, cIMObjectPath) && (n = PILPARProfileInstProvUtils.getLPARState(cIMObjectPath, (CIMOMHandle)providerCIMOMHandle)) != 0) {
            throw new PIHscServerException("07D1", new String[]{string2}, null);
        }
        System.out.println("Exiting checkTaskPrereqs");
    }

    public static int getLPARState(CIMObjectPath cIMObjectPath, CIMOMHandle cIMOMHandle) throws PIHscServerException {
        int n = -1;
        CIMInstance cIMInstance = null;
        try {
            Vector vector = CimomWrapper.associators(cIMOMHandle, new CIMObjectPath("IBMHSC_PartitionProfile", "root/ibmhscS1_0"), cIMObjectPath, null, null, null, false, false, null);
            if (vector != null) {
                int n2 = 0;
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    CIMInstance cIMInstance2 = (CIMInstance)enumeration.nextElement();
                    System.out.println("Next element " + n2++ + " = " + cIMInstance2);
                    cIMInstance = cIMInstance2;
                }
            }
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace();
            throw new PIHscServerException("1585", cIMException);
        }
        try {
            n = ((UnsignedInt8)cIMInstance.getProperty("PartitionState").getValue().getValue()).intValue();
            System.out.println("LPAR State = " + n);
        }
        catch (Throwable throwable) {
            throw new PIHscServerException("2523", new String[]{"R50Partition.PartitionState"}, throwable);
        }
        System.out.println("LEAVING getLPARState, lparState = " + n);
        return n;
    }

    public static void delActiveProfAss(ProviderCIMOMHandle providerCIMOMHandle, CIMObjectPath cIMObjectPath) throws CIMException {
        System.out.println("JPDelete:  Entering delActiveProfAss");
        Vector vector = CimomWrapper.referenceNames((CIMOMHandle)providerCIMOMHandle, new CIMObjectPath("IBMHSC_ActivatedLparProfile", "root/ibmhscS1_0"), cIMObjectPath, null);
        PIPartitionInstProvUtils.deleteAllElements(providerCIMOMHandle, vector);
        System.out.println("JPDelete:  Exiting delActiveProfAss");
    }

    public static void delSysProfAss(ProviderCIMOMHandle providerCIMOMHandle, CIMObjectPath cIMObjectPath) throws PIHscServerException, CIMException {
        System.out.println("JPDelete:  Entering delSysProfAss");
        Vector vector = CimomWrapper.referenceNames((CIMOMHandle)providerCIMOMHandle, new CIMObjectPath("IBMHSC_InSysProfile", "root/ibmhscS1_0"), cIMObjectPath, null);
        Vector vector2 = CimomWrapper.associatorNames((CIMOMHandle)providerCIMOMHandle, new CIMObjectPath("IBMHSC_InSysProfile", "root/ibmhscS1_0"), cIMObjectPath, "IBMHSC_SystemProfile", "PartComponent", "GroupComponent");
        for (int i = 0; i < vector2.size(); ++i) {
            CIMObjectPath cIMObjectPath2 = (CIMObjectPath)vector2.elementAt(i);
            Enumeration enumeration = CimomWrapper.referenceNames((CIMOMHandle)providerCIMOMHandle, new CIMObjectPath("IBMHSC_InSysProfile", "root/ibmhscV3_2"), cIMObjectPath2, null).elements();
            System.out.println("inSysProf enumeration: " + enumeration);
            if (!enumeration.hasMoreElements()) {
                PISysProfileUtils.deleteSysProfAndAssocs(cIMObjectPath2, providerCIMOMHandle);
                continue;
            }
            System.out.println("there's an element in here!");
            CIMObjectPath cIMObjectPath3 = (CIMObjectPath)enumeration.nextElement();
            System.out.println("element: " + cIMObjectPath3);
            CIMInstance cIMInstance = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath2, new CIMClass("IBMHSC_SystemProfile"), false);
            String string = (String)cIMInstance.getProperty("Name").getValue().getValue();
            int n = Integer.parseInt(string);
            String string2 = (String)cIMInstance.getProperty("SystemName").getValue().getValue();
            System.out.println("sysProfId: " + string);
            System.out.println("cecName: " + string2);
            CIMInstance cIMInstance2 = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, new CIMClass("IBMHSC_LparProfile"), false);
            String string3 = (String)cIMInstance2.getProperty("SettingID").getValue().getValue();
            System.out.println("profSettingID: " + string3);
            int n2 = Integer.parseInt(string3);
            PIHMCSaveArea pIHMCSaveArea = PIHMCSaveArea.getPIHMCSaveAreaInstance(string2);
            pIHMCSaveArea.deleteLparProfileFromSysProfile(n, n2);
            System.out.println("Removed profile association from sys profile in NVRAM");
            PISystemProfUpdater pISystemProfUpdater = new PISystemProfUpdater((CIMOMHandle)providerCIMOMHandle, cIMObjectPath2, cIMInstance);
            pISystemProfUpdater.update();
        }
        System.out.println("JPDelete:  Exiting delSysProfAss");
    }

    public static void delProfLPARAss(ProviderCIMOMHandle providerCIMOMHandle, CIMObjectPath cIMObjectPath) throws CIMException {
        System.out.println("JPDelete:  Entering delProfLPARAss");
        CIMObjectPath cIMObjectPath2 = new CIMObjectPath("IBMHSC_PartitionProfile", "root/ibmhscS1_0");
        Vector vector = CimomWrapper.referenceNames((CIMOMHandle)providerCIMOMHandle, new CIMObjectPath("IBMHSC_PartitionProfile", "root/ibmhscS1_0"), cIMObjectPath, null);
        PIPartitionInstProvUtils.deleteAllElements(providerCIMOMHandle, vector);
        System.out.println("JPDelete:  Exiting delProfLPARAss");
    }

    public static boolean theActiveProfile(ProviderCIMOMHandle providerCIMOMHandle, CIMObjectPath cIMObjectPath) {
        boolean bl = false;
        System.out.println("JPDelete:  Entering theActiveProfile");
        try {
            Vector vector = CimomWrapper.referenceNames((CIMOMHandle)providerCIMOMHandle, new CIMObjectPath("IBMHSC_ActivatedLparProfile", "root/ibmhscS1_0"), cIMObjectPath, null);
            if (vector != null && !vector.isEmpty()) {
                bl = true;
            }
        }
        catch (CIMException cIMException) {
            bl = false;
        }
        System.out.println("JPDelete:  Exiting theActiveProfile");
        return bl;
    }

    public static int getProfID(CIMObjectPath cIMObjectPath) {
        int n = -1;
        try {
            Vector vector = cIMObjectPath.getKeys();
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                CIMProperty cIMProperty = (CIMProperty)vector.elementAt(i);
                if (!cIMProperty.getName().equals("SettingID")) continue;
                String string = (String)cIMProperty.getValue().getValue();
                n = Integer.parseInt(string);
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    private static void printVector(Vector vector, String string) {
        System.out.println(string);
        if (vector == null || vector.size() < 1) {
            return;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration != null && enumeration.hasMoreElements()) {
            CIMObjectPath cIMObjectPath = (CIMObjectPath)enumeration.nextElement();
            System.out.println("JPD: PrintVector:  ------------ Next Element -----------");
            System.out.println("JPD: PrintVector:  nameSpace = " + cIMObjectPath.getNameSpace());
            System.out.println("JPD: PrintVector:  cp        = " + cIMObjectPath);
            System.out.println("JPD: PrintVector:  -------------------------------------");
        }
    }

    public static void checkProfProperties(CIMInstance cIMInstance, CIMInstance cIMInstance2) throws PIHscServerException {
        String string;
        Trace.trace("appphscT", "PILPARProfileInstProvUtils.checkProfProperties ->");
        Trace.trace("appphscF", "profInst = " + cIMInstance);
        Trace.trace("appphscF", "oldProfInst = " + cIMInstance2);
        System.out.println("profInst = " + cIMInstance);
        boolean bl = false;
        try {
            string = (UnsignedInt8)cIMInstance.getProperty("FullSysPartProf").getValue().getValue();
            if (string.intValue() != 0) {
                bl = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        string = "";
        try {
            string = (String)cIMInstance.getProperty("PartitionName").getValue().getValue();
        }
        catch (Throwable throwable) {
            throw new PIHscServerException("2523", new String[]{"R50LparProfile.PartitionName"}, throwable);
        }
        if (3 <= Trace.LEVEL) {
            Trace.trace("appphscD", "partitionName = " + string);
        }
        System.out.println("partitionName = " + string);
        String string2 = string.substring(string.indexOf(42) + 1);
        OmCecMgr omCecMgr = OmCecMgr.getCecMgr(string2);
        OmLparMgr omLparMgr = null;
        try {
            omLparMgr = omCecMgr.getLparMgr(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (bl) {
            PILPARProfileInstProvUtils.fullResLparProfChecks(cIMInstance, cIMInstance2, omLparMgr, omCecMgr);
        } else {
            PILPARProfileInstProvUtils.normLparProfChecks(cIMInstance, cIMInstance2, omLparMgr, omCecMgr);
        }
        Trace.trace("appphscT", "<- PILPARProfileInstProvUtils.checkProfProperties");
    }

    private static void commonLparProfChecks(CIMInstance cIMInstance, CIMInstance cIMInstance2, OmLparMgr omLparMgr, OmCecMgr omCecMgr) throws PIHscServerException {
        Trace.trace("appphscT", "PILPARProfileInstProvUtils.commonLparProfChecks ->");
        String string = "";
        try {
            string = (String)cIMInstance.getProperty("UserDefinedName").getValue().getValue();
        }
        catch (Throwable throwable) {
            throw new PIHscServerException("058C", throwable);
        }
        if (string == null || string.trim().length() <= 0) {
            throw new PIHscServerException("058C", null);
        }
        PILPARProfileInstProvUtils.validateProfUserDefName(string);
        int n = PILPARProfileInstProvUtils.extractOsType(omLparMgr);
        RObject rObject = omCecMgr.getObject();
        FspCmdHelper fspCmdHelper = omCecMgr.getCmdHelper();
        int n2 = 0;
        try {
            n2 = ((UnsignedInt16)rObject.getProperty("LMBSize")).intValue();
        }
        catch (Throwable throwable) {
            throw new PIHscServerException("2523", new String[]{"R50ComputerSystem.LMBSize"}, throwable);
        }
        long l = 0L;
        try {
            l = ((UnsignedInt32)rObject.getProperty("InstalledMemory")).longValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        PILPARProfileInstProvUtils.checkIO(n, cIMInstance, cIMInstance2, omCecMgr);
        PILPARProfileInstProvUtils.reserveMemChecks(n, n2, l, cIMInstance, omCecMgr);
        PILPARProfileInstProvUtils.checkOptiSetting(n, cIMInstance, omCecMgr);
        PILPARProfileInstProvUtils.checkPolicies(n, cIMInstance);
        PILPARProfileInstProvUtils.checkPowerControllingLpars(n, cIMInstance, omCecMgr);
        Trace.trace("appphscT", "<- PILPARProfileInstProvUtils.commonLparProfsChecks");
    }

    public static void fullResLparProfChecks(CIMInstance cIMInstance, CIMInstance cIMInstance2, OmLparMgr omLparMgr, OmCecMgr omCecMgr) throws PIHscServerException {
        Trace.trace("appphscT", "PILPARProfileInstProvUtils.fullResLparProfChecks ->");
        int n = PILPARProfileInstProvUtils.extractOsType(omLparMgr);
        if (n == 129) {
            RObject rObject = omCecMgr.getObject();
            int n2 = 0;
            try {
                n2 = ((UnsignedInt16)rObject.getProperty("MaxI5OSProcUnits")).intValue();
            }
            catch (Throwable throwable) {
                throw new PIHscServerException("2523", new String[]{"R50ComputerSystem.MaxI5OSProcUnits"}, throwable);
            }
            if (n2 > 0) {
                System.out.println("OS/400 profile not allowed to be full system on pSeries!");
                throw new PIHscServerException("0650", null);
            }
        }
        PILPARProfileInstProvUtils.commonLparProfChecks(cIMInstance, cIMInstance2, omLparMgr, omCecMgr);
        Trace.trace("appphscT", "<- PILPARProfileInstProvUtils.fullResLparProfChecks");
    }

    public static void normLparProfChecks(CIMInstance cIMInstance, CIMInstance cIMInstance2, OmLparMgr omLparMgr, OmCecMgr omCecMgr) throws PIHscServerException {
        Trace.trace("appphscT", "PILPARProfileInstProvUtils.normalLparProfChecks ->");
        PILPARProfileInstProvUtils.commonLparProfChecks(cIMInstance, cIMInstance2, omLparMgr, omCecMgr);
        int n = PILPARProfileInstProvUtils.extractOsType(omLparMgr);
        RObject rObject = omCecMgr.getObject();
        FspCmdHelper fspCmdHelper = omCecMgr.getCmdHelper();
        int n2 = 0;
        try {
            n2 = ((UnsignedInt16)rObject.getProperty("LMBSize")).intValue();
        }
        catch (Throwable throwable) {
            throw new PIHscServerException("2523", new String[]{"R50ComputerSystem.LMBSize"}, throwable);
        }
        long l = 0L;
        try {
            l = ((UnsignedInt32)rObject.getProperty("InstalledMemory")).longValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        PILPARProfileInstProvUtils.normalLparMemChecks(n, n2, l, cIMInstance, omCecMgr);
        PILPARProfileInstProvUtils.checkProcSettings(cIMInstance, omCecMgr, n);
        PILPARProfileInstProvUtils.interactiveSettingCheck(n, cIMInstance, omCecMgr);
        PILPARProfileInstProvUtils.checkVirtualIOSetting(n, cIMInstance, omCecMgr, omLparMgr);
        Trace.trace("appphscT", "<- PILPARProfileInstProvUtils.normLparProfChecks");
    }

    public static void checkVirtualIOSetting(int n, CIMInstance cIMInstance, OmCecMgr omCecMgr, OmLparMgr omLparMgr) throws PIHscServerException {
        Trace.trace("appphscT", "PILPARProfileInstProvUtils.checkVirtualIOSetting ->");
        Trace.trace("appphscF", "PILPARProfileInstProvUtils.lparType" + n);
        int n2 = 0;
        try {
            n2 = ((UnsignedInt16)cIMInstance.getProperty("MaxVirtualSlots").getValue().getValue()).intValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Vector vector = new Vector();
        PILPARProfileInstProvUtils.checkVirSerialSettings(cIMInstance, n2, omCecMgr, vector, omLparMgr);
        PILPARProfileInstProvUtils.checkVirScsiSettings(cIMInstance, n2, omCecMgr, vector, omLparMgr);
        PILPARProfileInstProvUtils.checkVirEthernetSettings(cIMInstance, n2, omCecMgr, vector);
        Trace.trace("appphscT", "<- PILPARProfileInstProvUtils.checkVirtualIOSetting");
    }

    public static void checkProcSettings(CIMInstance cIMInstance, OmCecMgr omCecMgr, int n) throws PIHscServerException {
        Trace.trace("appphscT", "PILPARProfileInstProvUtils.checkProcSettings ->");
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        boolean bl = false;
        RObject rObject = omCecMgr.getObject();
        if (3 <= Trace.LEVEL) {
            Trace.trace("appphscD", "cecObject = " + rObject);
        }
        FspCmdHelper fspCmdHelper = omCecMgr.getCmdHelper();
        int n8 = 0;
        int n9 = 0;
        boolean bl2 = false;
        int n10 = 0;
        try {
            n2 = ((UnsignedInt16)cIMInstance.getProperty("MinimumCPUCount").getValue().getValue()).intValue();
        }
        catch (Throwable throwable) {
            throw new PIHscServerException("07E2", null);
        }
        try {
            n3 = ((UnsignedInt16)cIMInstance.getProperty("DesiredCPUCount").getValue().getValue()).intValue();
        }
        catch (Throwable throwable) {
            throw new PIHscServerException("07E2", null);
        }
        try {
            n4 = ((UnsignedInt16)cIMInstance.getProperty("MaximumCPUCount").getValue().getValue()).intValue();
        }
        catch (Throwable throwable) {
            throw new PIHscServerException("07E2", null);
        }
        try {
            n5 = ((UnsignedInt8)cIMInstance.getProperty("ProcMode").getValue().getValue()).shortValue();
        }
        catch (Throwable throwable) {
            throw new PIHscServerException("07E2", null);
        }
        try {
            n6 = ((UnsignedInt8)cIMInstance.getProperty("SharingMode").getValue().getValue()).intValue();
        }
        catch (Throwable throwable) {
            throw new PIHscServerException("07E2", null);
        }
        if (n == 129) {
            try {
                n7 = ((UnsignedInt16)rObject.getProperty("MaxI5OSProcUnits")).intValue();
            }
            catch (Throwable throwable) {
                throw new PIHscServerException("1585", null);
            }
        }
        if (n2 > n3 || n3 > n4 || n2 <= 0) {
            throw new PIHscServerException("07DD", null);
        }
        long l4 = 0L;
        try {
            l4 = ((UnsignedInt32)rObject.getProperty("ConfigurableProcUnits")).longValue();
        }
        catch (Throwable throwable) {
            l4 = 0L;
        }
        boolean bl3 = false;
        if (l4 / 100L <= 0L) {
            bl3 = true;
        }
        if (n5 == 255) {
            if (bl3) {
                throw new PIHscServerException("1456", null);
            }
            if (n == 129 && n7 > 0 && n4 > n7 / 100) {
                throw new PIHscServerException("0651", new String[]{Integer.toString(n7 / 100)}, null);
            }
            long l5 = 0L;
            try {
                l5 = ((UnsignedInt32)rObject.getProperty("InstalledProcessors")).longValue();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if ((long)n4 > l5 / 100L) {
                throw new PIHscServerException("1456", null);
            }
            try {
                n9 = ((UnsignedInt16)rObject.getProperty("MaxDedicatedProcPerPartition")).intValue();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (n4 > n9) {
                throw new PIHscServerException("1456", null);
            }
            if (n6 != 0 && n6 != 1) {
                throw new PIHscServerException("0621", null);
            }
        } else {
            BitSet bitSet = fspCmdHelper.getHypervisorCapabilities();
            if (!bitSet.get(28)) {
                throw new PIHscServerException("0281", null);
            }
            try {
                n8 = ((UnsignedInt8)rObject.getProperty("MaxProcPools")).intValue();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (n5 >= n8) {
                throw new PIHscServerException("1469", null);
            }
            try {
                l = ((UnsignedInt32)cIMInstance.getProperty("MinProcUnit").getValue().getValue()).longValue();
            }
            catch (Throwable throwable) {
                throw new PIHscServerException("07E2", null);
            }
            try {
                l2 = ((UnsignedInt32)cIMInstance.getProperty("DesiredProcUnit").getValue().getValue()).longValue();
            }
            catch (Throwable throwable) {
                throw new PIHscServerException("07E2", null);
            }
            try {
                l3 = ((UnsignedInt32)cIMInstance.getProperty("MaxProcUnit").getValue().getValue()).longValue();
            }
            catch (Throwable throwable) {
                throw new PIHscServerException("07E2", null);
            }
            if (n == 129 && n7 > 0 && l3 > (long)n7) {
                throw new PIHscServerException("0652", new String[]{Double.toString((double)n7 / 100.0)}, null);
            }
            if (l > l2 || l2 > l3 || l <= 0L) {
                throw new PIHscServerException("0622", null);
            }
            try {
                n10 = ((UnsignedInt16)rObject.getProperty("MinProcUnit")).intValue();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (l / (long)n2 > 100L || l / (long)n2 < (long)n10 || l2 / (long)n3 > 100L || l2 / (long)n3 < (long)n10 || l3 / (long)n4 > 100L || l3 / (long)n4 < (long)n10) {
                throw new PIHscServerException("0622", null);
            }
            int n11 = 0;
            try {
                n11 = ((UnsignedInt16)rObject.getProperty("MaxVirProcPerPartition")).intValue();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (n4 > n11) {
                throw new PIHscServerException("1456", null);
            }
            UnsignedInt8 unsignedInt8 = null;
            try {
                unsignedInt8 = (UnsignedInt8)cIMInstance.getProperty("UncappedWeight").getValue().getValue();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (n6 != 0 && n6 != 1) {
                throw new PIHscServerException("0622", null);
            }
            if (n6 == 0) {
                if (unsignedInt8 != null && unsignedInt8.intValue() != 0) {
                    throw new PIHscServerException("0622", null);
                }
            } else {
                if (bl3) {
                    throw new PIHscServerException("147D", null);
                }
                if (unsignedInt8 != null && unsignedInt8.intValue() > 255) {
                    throw new PIHscServerException("0622", null);
                }
                if (n == 129 && n7 > 0 && n4 * 100 > n7) {
                    throw new PIHscServerException("0653", new String[]{Integer.toString(n7 / 100)}, null);
                }
            }
        }
        Trace.trace("appphscT", "<- PILPARProfileInstProvUtils.checkProcSettings");
    }

    public static void checkVirSerialSettings(CIMInstance cIMInstance, int n, OmCecMgr omCecMgr, Vector vector, OmLparMgr omLparMgr) throws PIHscServerException {
        Object object;
        Trace.trace("appphscT", "PILPARProfileInstProvUtils.checkVirSerialSettings ->");
        Trace.trace("appphscF", "PILPARProfileInstProvUtils.maxVirSlot = " + n);
        Vector vector2 = null;
        Vector vector3 = null;
        Vector vector4 = null;
        Vector vector5 = null;
        Vector vector6 = null;
        Vector vector7 = null;
        boolean bl = true;
        int n2 = PILPARProfileInstProvUtils.extractOsType(omLparMgr);
        int n3 = 0;
        try {
            object = (String)cIMInstance.getProperty("PartitionName").getValue().getValue();
            n3 = Integer.parseInt(((String)object).substring(0, ((String)object).indexOf(42)));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (n2 == 129) {
            object = omCecMgr.getObject();
            long l = 0L;
            try {
                l = ((UnsignedInt32)((RObject)object).getProperty("RuntimeCapability")).longValue();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if ((l & 0x2000000L) != 0L) {
                bl = false;
            }
        }
        try {
            vector2 = (Vector)cIMInstance.getProperty("VirSerialServerLPARs").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            vector3 = (Vector)cIMInstance.getProperty("VirSerialServerSlotNum").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            vector4 = (Vector)cIMInstance.getProperty("VirSerialAdapters").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            vector5 = (Vector)cIMInstance.getProperty("VirSerialDeviceAttributes").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            vector6 = (Vector)cIMInstance.getProperty("VirSerialSupportHMCClients").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            vector7 = (Vector)cIMInstance.getProperty("VirSerialSlotReqDesAttribute").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!(vector2 != null && vector3.size() != 0 || vector3 != null && vector3.size() != 0 || vector4 != null && vector4.size() != 0 || vector5 != null && vector5.size() != 0 || vector6 != null && vector6.size() != 0 || vector7 != null && vector7.size() != 0)) {
            return;
        }
        if (vector2 == null || vector3.size() == 0 || vector3 == null || vector3.size() == 0 || vector4 == null || vector4.size() == 0 || vector5 == null || vector5.size() == 0 || vector6 == null || vector6.size() == 0 || vector7 == null || vector7.size() == 0) {
            throw new PIHscServerException("061A", null);
        }
        if (vector3.size() != vector3.size() || vector3.size() != vector4.size() || vector3.size() != vector5.size() || vector3.size() != vector6.size() || vector3.size() != vector7.size()) {
            throw new PIHscServerException("061A", null);
        }
        for (int i = 0; i < vector4.size(); ++i) {
            UnsignedInt16 unsignedInt16;
            Object object2;
            UnsignedInt8 unsignedInt8;
            boolean bl2 = false;
            UnsignedInt16 unsignedInt162 = (UnsignedInt16)vector4.elementAt(i);
            if (unsignedInt162 != null) {
                if (unsignedInt162.intValue() >= n) {
                    throw new PIHscServerException("1515", null);
                }
                if (vector.contains(unsignedInt162)) {
                    throw new PIHscServerException("1514", null);
                }
                vector.add(unsignedInt162);
                if (unsignedInt162.intValue() == 0 || unsignedInt162.intValue() == 1) {
                    bl2 = true;
                }
            }
            if ((unsignedInt8 = (UnsignedInt8)vector5.elementAt(i)) != null) {
                object2 = (UnsignedInt16)vector2.elementAt(i);
                unsignedInt16 = (UnsignedInt16)vector3.elementAt(i);
                if (unsignedInt8.intValue() == 0) {
                    if (bl2) {
                        throw new PIHscServerException("07DF", null);
                    }
                    if (!bl) {
                        throw new PIHscServerException("07C1", null);
                    }
                    if (object2 == null || object2.equals((Object)new UnsignedInt16(65535)) || unsignedInt16 == null || unsignedInt16.equals((Object)new UnsignedInt16(65535))) {
                        throw new PIHscServerException("061A", null);
                    }
                    if (n3 == object2.intValue() && unsignedInt162.equals((Object)unsignedInt16)) {
                        throw new PIHscServerException("061A", null);
                    }
                } else if (object2 == null || unsignedInt16 == null) {
                    if (!bl2) {
                        throw new PIHscServerException("061A", null);
                    }
                } else if (!object2.equals((Object)new UnsignedInt16(65535)) || !unsignedInt16.equals((Object)new UnsignedInt16(65535))) {
                    if (object2.equals((Object)new UnsignedInt16(65535)) || unsignedInt16.equals((Object)new UnsignedInt16(65535))) {
                        throw new PIHscServerException("061A", null);
                    }
                    if (n3 == object2.intValue() && unsignedInt162.equals((Object)unsignedInt16)) {
                        throw new PIHscServerException("061A", null);
                    }
                }
            }
            if (!((String)(object2 = (String)vector7.elementAt(i))).equalsIgnoreCase("r") && !((String)object2).equalsIgnoreCase("d")) {
                throw new PIHscServerException("061A", null);
            }
            unsignedInt16 = (UnsignedInt8)vector6.elementAt(i);
            if (unsignedInt16 != null && unsignedInt16.intValue() != 1 && unsignedInt16.intValue() != 0) {
                throw new PIHscServerException("061A", null);
            }
            if (!bl2 || unsignedInt16 == null || unsignedInt16.intValue() != 0) continue;
            throw new PIHscServerException("07DF", null);
        }
        Trace.trace("appphscT", "<- PILPARProfileInstProvUtils.checkVirSerialSettings");
    }

    public static void checkVirScsiSettings(CIMInstance cIMInstance, int n, OmCecMgr omCecMgr, Vector vector, OmLparMgr omLparMgr) throws PIHscServerException {
        Object object;
        Trace.trace("appphscT", "PILPARProfileInstProvUtils.checkVirScsiSettings ->");
        Vector vector2 = null;
        Vector vector3 = null;
        Vector vector4 = null;
        Vector vector5 = null;
        Vector vector6 = null;
        Vector vector7 = null;
        boolean bl = true;
        int n2 = PILPARProfileInstProvUtils.extractOsType(omLparMgr);
        int n3 = 0;
        try {
            object = (String)cIMInstance.getProperty("PartitionName").getValue().getValue();
            n3 = Integer.parseInt(((String)object).substring(0, ((String)object).indexOf(42)));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (n2 == 129) {
            object = omCecMgr.getObject();
            long l = 0L;
            try {
                l = ((UnsignedInt32)((RObject)object).getProperty("RuntimeCapability")).longValue();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if ((l & 0x2000000L) != 0L) {
                bl = false;
            }
        } else if (n2 != 65) {
            bl = false;
        }
        try {
            vector2 = (Vector)cIMInstance.getProperty("VirSCSIServerLPARs").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            vector3 = (Vector)cIMInstance.getProperty("VirSCSIServerSlotNum").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            vector4 = (Vector)cIMInstance.getProperty("VirSCSIAdapters").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            vector5 = (Vector)cIMInstance.getProperty("VirSCSIDeviceAttributes").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            vector6 = (Vector)cIMInstance.getProperty("VirSCSISupportHMCClients").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            vector7 = (Vector)cIMInstance.getProperty("VirSCSISlotReqDesAttribute").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!(vector2 != null && vector3.size() != 0 || vector3 != null && vector3.size() != 0 || vector4 != null && vector4.size() != 0 || vector5 != null && vector5.size() != 0 || vector6 != null && vector6.size() != 0 || vector7 != null && vector7.size() != 0)) {
            return;
        }
        if (vector2 == null || vector3.size() == 0 || vector3 == null || vector3.size() == 0 || vector4 == null || vector4.size() == 0 || vector5 == null || vector5.size() == 0 || vector6 == null || vector6.size() == 0 || vector7 == null || vector7.size() == 0) {
            throw new PIHscServerException("061A", null);
        }
        if (vector3.size() != vector3.size() || vector3.size() != vector4.size() || vector3.size() != vector5.size() || vector3.size() != vector6.size() || vector3.size() != vector7.size()) {
            throw new PIHscServerException("061A", null);
        }
        for (int i = 0; i < vector4.size(); ++i) {
            UnsignedInt16 unsignedInt16;
            Object object2;
            UnsignedInt8 unsignedInt8;
            UnsignedInt16 unsignedInt162 = (UnsignedInt16)vector4.elementAt(i);
            if (unsignedInt162 != null) {
                if (unsignedInt162.intValue() >= n) {
                    throw new PIHscServerException("1515", null);
                }
                if (vector.contains(unsignedInt162)) {
                    throw new PIHscServerException("1514", null);
                }
                vector.add(unsignedInt162);
                if (unsignedInt162.intValue() == 0 || unsignedInt162.intValue() == 1) {
                    throw new PIHscServerException("07DF", null);
                }
            }
            if ((unsignedInt8 = (UnsignedInt8)vector5.elementAt(i)) != null) {
                object2 = (UnsignedInt16)vector2.elementAt(i);
                unsignedInt16 = (UnsignedInt16)vector3.elementAt(i);
                if (unsignedInt8.intValue() == 0) {
                    if (object2 == null || object2.equals((Object)new UnsignedInt16(65535)) || unsignedInt16 == null || unsignedInt16.equals((Object)new UnsignedInt16(65535))) {
                        throw new PIHscServerException("061A", null);
                    }
                    if (n3 == object2.intValue() && unsignedInt162.equals((Object)unsignedInt16)) {
                        throw new PIHscServerException("061A", null);
                    }
                } else {
                    if (!bl) {
                        throw new PIHscServerException("07C0", null);
                    }
                    if (object2 == null || unsignedInt16 == null) {
                        throw new PIHscServerException("061A", null);
                    }
                    if (!object2.equals((Object)new UnsignedInt16(65535)) || !unsignedInt16.equals((Object)new UnsignedInt16(65535))) {
                        if (object2.equals((Object)new UnsignedInt16(65535)) || unsignedInt16.equals((Object)new UnsignedInt16(65535))) {
                            throw new PIHscServerException("061A", null);
                        }
                        if (n3 == object2.intValue() && unsignedInt162.equals((Object)unsignedInt16)) {
                            throw new PIHscServerException("061A", null);
                        }
                    }
                }
            }
            if (!((String)(object2 = (String)vector7.elementAt(i))).equalsIgnoreCase("r") && !((String)object2).equalsIgnoreCase("d")) {
                throw new PIHscServerException("061A", null);
            }
            unsignedInt16 = (UnsignedInt8)vector6.elementAt(i);
            if (unsignedInt16 == null || unsignedInt16.intValue() == 1 || unsignedInt16.intValue() == 0) continue;
            throw new PIHscServerException("061A", null);
        }
        System.out.println("===== PILPARProfileInstProvUtils: =======");
        System.out.println("VirSCSIServerLPARs = " + vector2);
        System.out.println("VirSCSIServerSlotNum = " + vector3);
        System.out.println("VirSCSIAdapters = " + vector4);
        Trace.trace("appphscT", "<- PILPARProfileInstProv.checkVirScsiSettings");
    }

    public static void checkVirEthernetSettings(CIMInstance cIMInstance, int n, OmCecMgr omCecMgr, Vector vector) throws PIHscServerException {
        Trace.trace("appphscT", "PILPARProfileInstProvUtils.checkVirEthernetSettings ->");
        Vector vector2 = null;
        Vector vector3 = null;
        Vector vector4 = null;
        Vector vector5 = null;
        Vector vector6 = null;
        Vector vector7 = null;
        Vector vector8 = null;
        try {
            vector2 = (Vector)cIMInstance.getProperty("VirtualLanSlotIDs").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            vector3 = (Vector)cIMInstance.getProperty("IEEE").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            vector4 = (Vector)cIMInstance.getProperty("VLANTrunkAdapter").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            vector8 = (Vector)cIMInstance.getProperty("VLANSlotReqDesAttribute").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            vector5 = (Vector)cIMInstance.getProperty("PVLANID").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            vector6 = (Vector)cIMInstance.getProperty("AddVlanNum").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            vector7 = (Vector)cIMInstance.getProperty("AddVlans").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!(vector2 != null && vector2.size() != 0 || vector3 != null && vector3.size() != 0 || vector4 != null && vector4.size() != 0 || vector5 != null && vector5.size() != 0 || vector6 != null && vector6.size() != 0 || vector7 != null && vector7.size() != 0 || vector8 != null && vector8.size() != 0)) {
            return;
        }
        if (vector2 == null || vector2.size() == 0 || vector3 == null || vector3.size() == 0 || vector4 == null || vector4.size() == 0 || vector5 == null || vector5.size() == 0 || vector6 == null || vector6.size() == 0 || vector8 == null || vector8.size() == 0) {
            throw new PIHscServerException("061A", null);
        }
        if (vector2.size() != vector3.size() || vector2.size() != vector4.size() || vector2.size() != vector5.size() || vector2.size() != vector6.size() || vector2.size() != vector8.size()) {
            throw new PIHscServerException("061A", null);
        }
        int n2 = 0;
        int n3 = 0;
        try {
            RObject rObject = omCecMgr.getObject();
            n3 = ((UnsignedInt16)rObject.getProperty("MaxVLANIDsPerPort")).intValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (int i = 0; i < vector2.size(); ++i) {
            String string;
            UnsignedInt8 unsignedInt8;
            UnsignedInt16 unsignedInt16 = (UnsignedInt16)vector2.elementAt(i);
            if (unsignedInt16 != null) {
                if (unsignedInt16.intValue() >= n) {
                    throw new PIHscServerException("1515", null);
                }
                if (vector.contains(unsignedInt16)) {
                    throw new PIHscServerException("1514", null);
                }
                vector.add(unsignedInt16);
                if (unsignedInt16.intValue() == 0 || unsignedInt16.intValue() == 1) {
                    throw new PIHscServerException("07DF", null);
                }
            }
            if ((unsignedInt8 = (UnsignedInt8)vector3.elementAt(i)) != null) {
                int n4 = unsignedInt8.intValue();
                UnsignedInt16 unsignedInt162 = (UnsignedInt16)vector6.elementAt(i);
                if (n4 != 0 && n4 != 1) {
                    throw new PIHscServerException("061A", null);
                }
                if (n4 != 1) {
                    if (unsignedInt162 != null && unsignedInt162.intValue() != 0) {
                        throw new PIHscServerException("061A", null);
                    }
                } else if (unsignedInt162 != null) {
                    int n5 = unsignedInt162.intValue();
                    n2 += n5;
                    if (n5 > n3 - 1) {
                        throw new PIHscServerException("061A", null);
                    }
                }
            }
            if ((string = (String)vector8.elementAt(i)).equalsIgnoreCase("r") || string.equalsIgnoreCase("d")) continue;
            throw new PIHscServerException("061A", null);
        }
        if (vector7 == null ? n2 != 0 : vector7.size() != n2) {
            throw new PIHscServerException("061A", null);
        }
        Trace.trace("appphscT", "<- PILPARProfileInstProvUtils.checkVirEthernetSettings ->");
    }

    public static void checkOptiSetting(int n, CIMInstance cIMInstance, OmCecMgr omCecMgr) throws PIHscServerException {
        Trace.trace("appphscT", "PILPARProfileInstProvUtils.checkOptiSetting ->");
        UnsignedInt8 unsignedInt8 = null;
        try {
            unsignedInt8 = (UnsignedInt8)cIMInstance.getProperty("VirtualOptiConnectPool").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        UnsignedInt8 unsignedInt82 = null;
        try {
            unsignedInt82 = (UnsignedInt8)cIMInstance.getProperty("HSLOptiConnectPool").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (n == 1 || n == 65 ? unsignedInt8 != null && unsignedInt8.intValue() != 0 || unsignedInt82 != null && unsignedInt82.intValue() != 0 : n == 4 && unsignedInt8 != null && unsignedInt8.intValue() != 0) {
            throw new PIHscServerException("0640", null);
        }
        int n2 = 0;
        int n3 = 0;
        RObject rObject = omCecMgr.getObject();
        try {
            n2 = ((UnsignedInt8)rObject.getProperty("MaxVirOptiPools")).intValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            n3 = ((UnsignedInt8)rObject.getProperty("MaxHSLOptiPools")).intValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (unsignedInt8 != null && unsignedInt8.intValue() > n2) {
            throw new PIHscServerException("147E", null);
        }
        if (unsignedInt82 != null && unsignedInt82.intValue() > n3) {
            throw new PIHscServerException("147F", null);
        }
        Trace.trace("appphscT", "<- PILPARProfileInstProvUtils.checkOptSettings");
    }

    public static void checkPolicies(int n, CIMInstance cIMInstance) throws PIHscServerException {
        Trace.trace("appphscT", "PILPARProfileInstProvUtils.checkPolicies ->");
        UnsignedInt8 unsignedInt8 = null;
        try {
            unsignedInt8 = (UnsignedInt8)cIMInstance.getProperty("BootMode").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (n == 1 || n == 65 || n == 4) {
            if (unsignedInt8 == null) {
                throw new PIHscServerException("061B", null);
            }
            int n2 = unsignedInt8.intValue();
            if (n2 != 1 && n2 != 3 && n2 != 5 && n2 != 2 && n2 != 4) {
                throw new PIHscServerException("061B", null);
            }
        }
        UnsignedInt8 unsignedInt82 = null;
        try {
            unsignedInt82 = (UnsignedInt8)cIMInstance.getProperty("AutoIPLEnabled").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (unsignedInt82 != null && unsignedInt82.intValue() != 0 && unsignedInt82.intValue() != 1) {
            throw new PIHscServerException("061B", null);
        }
        UnsignedInt8 unsignedInt83 = null;
        try {
            unsignedInt83 = (UnsignedInt8)cIMInstance.getProperty("SFPSurveillance").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (unsignedInt83 != null && unsignedInt83.intValue() != 0 && unsignedInt83.intValue() != 1) {
            throw new PIHscServerException("061B", null);
        }
        Trace.trace("appphscT", "<- PILPARProfileInstProvUtils.checkPolicies");
    }

    public static void checkPowerControllingLpars(int n, CIMInstance cIMInstance, OmCecMgr omCecMgr) throws PIHscServerException {
        Trace.trace("appphscT", "PILPARProfileInstProvUtils.checkPowerControllingLpars ->");
        Vector vector = null;
        try {
            vector = (Vector)cIMInstance.getProperty("HostingPartitions").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (vector != null && vector.size() > 0) {
            RObject rObject = omCecMgr.getObject();
            int n2 = 0;
            try {
                n2 = ((UnsignedInt16)rObject.getProperty("MaxHostingLpars")).intValue();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (vector.size() > n2) {
                throw new PIHscServerException("146E", null);
            }
        }
        Trace.trace("appphscT", "<- PILPARProfileInstProv.checkingPowerControllingLpars");
    }

    public static void validateProfUserDefName(String string) throws PIHscServerException {
        Trace.trace("appphscT", "PILPARProfileInstProvUtils.validateProfUserDefName ->");
        if (string.trim().length() > 31) {
            throw new PIHscServerException("058D", new String[]{"31"}, null);
        }
        if (string.trim().length() <= 0) {
            throw new PIHscServerException("058C", null);
        }
        PIHscProviderUtils.validateUserDefName(string);
        Trace.trace("appphscT", "<- PILPARProfileInstProvUtils.validateProfUserDefName");
    }

    public static void checkIO(int n, CIMInstance cIMInstance, CIMInstance cIMInstance2, OmCecMgr omCecMgr) throws PIHscServerException {
        String string;
        Object object;
        int n2;
        boolean bl;
        int n3;
        Object object2;
        Trace.trace("appphscT", "PILPARProfileInstProvUtils.checkIO ->");
        int n4 = 0;
        int n5 = 0;
        try {
            n4 = ((UnsignedInt16)cIMInstance.getProperty("MaxVirtualSlots").getValue().getValue()).intValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            RObject rObject = omCecMgr.getObject();
            n5 = ((UnsignedInt16)rObject.getProperty("MaxNumberOfIoPools")).intValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        boolean bl2 = false;
        try {
            object2 = (UnsignedInt8)cIMInstance.getProperty("FullSysPartProf").getValue().getValue();
            if (object2.intValue() != 0) {
                bl2 = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        object2 = null;
        try {
            object2 = (Vector)cIMInstance.getProperty("IOSlots").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Vector vector = new Vector();
        try {
            vector = (Vector)cIMInstance2.getProperty("IOSlots").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (vector == null) {
            vector = new Vector();
        }
        Vector vector2 = null;
        try {
            vector2 = (Vector)cIMInstance.getProperty("IORequirement").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Vector vector3 = null;
        try {
            vector3 = (Vector)cIMInstance.getProperty("IOPoolIDs").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Vector vector4 = new Vector();
        try {
            vector4 = (Vector)cIMInstance.getProperty("PartitionIOPools").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (vector4 == null) {
            vector4 = new Vector();
        }
        UnsignedInt32 unsignedInt32 = null;
        try {
            unsignedInt32 = (UnsignedInt32)cIMInstance.getProperty("LoadSourceDRCIndex").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        UnsignedInt32 unsignedInt322 = null;
        try {
            unsignedInt322 = (UnsignedInt32)cIMInstance.getProperty("AltLoadSourceDRCIndex").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        UnsignedInt32 unsignedInt323 = null;
        try {
            unsignedInt323 = (UnsignedInt32)cIMInstance.getProperty("ConsoleDRCIndex").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        UnsignedInt32 unsignedInt324 = null;
        try {
            unsignedInt324 = (UnsignedInt32)cIMInstance.getProperty("AltConsoleDRCIndex").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        UnsignedInt32 unsignedInt325 = null;
        try {
            unsignedInt325 = (UnsignedInt32)cIMInstance.getProperty("ECSDRCIndex").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Vector vector5 = null;
        try {
            vector5 = (Vector)cIMInstance.getProperty("TaggedIOInfo").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        UnsignedInt32 unsignedInt326 = null;
        try {
            unsignedInt326 = (UnsignedInt32)cIMInstance2.getProperty("LoadSourceDRCIndex").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        UnsignedInt32 unsignedInt327 = null;
        try {
            unsignedInt327 = (UnsignedInt32)cIMInstance2.getProperty("AltLoadSourceDRCIndex").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        UnsignedInt32 unsignedInt328 = null;
        try {
            unsignedInt328 = (UnsignedInt32)cIMInstance2.getProperty("ConsoleDRCIndex").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        UnsignedInt32 unsignedInt329 = null;
        try {
            unsignedInt329 = (UnsignedInt32)cIMInstance2.getProperty("AltConsoleDRCIndex").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        UnsignedInt32 unsignedInt3210 = null;
        try {
            unsignedInt3210 = (UnsignedInt32)cIMInstance2.getProperty("ECSDRCIndex").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Hashtable hashtable = omCecMgr.getPhyIODrcIndexTable();
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(65535);
        if (object2 != null) {
            n3 = 0;
            bl = false;
            if (vector2 == null || vector2.size() <= 0) {
                n3 = 1;
            } else if (vector2.size() < ((Vector)object2).size()) {
                throw new PIHscServerException("0619", null);
            }
            if (vector3 == null || vector3.size() <= 0) {
                bl = true;
            } else if (vector3.size() < ((Vector)object2).size()) {
                throw new PIHscServerException("0619", null);
            }
            for (n2 = 0; n2 < ((Vector)object2).size(); ++n2) {
                object = (UnsignedInt32)((Vector)object2).elementAt(n2);
                String string2 = "null";
                try {
                    string2 = object.toString();
                }
                catch (Throwable throwable) {
                    string2 = null;
                }
                if (!hashtable.containsKey(object) && !vector.contains(object)) {
                    throw new PIHscServerException("150D", new String[]{Long.toHexString(object.longValue())}, null);
                }
                if (n3 == 0 && !(string = (String)vector2.elementAt(n2)).equalsIgnoreCase("r") && !string.equalsIgnoreCase("d")) {
                    throw new PIHscServerException("0619", null);
                }
                if (bl) continue;
                string = (UnsignedInt16)vector3.elementAt(n2);
                if (string != null && !string.equals((Object)unsignedInt16) && string.intValue() >= n5) {
                    throw new PIHscServerException("1468", null);
                }
                if (string.equals((Object)unsignedInt16) || vector4.contains(string) || ((Vector)object2).size() <= n2) continue;
                String string3 = omCecMgr.drcIndexToFullLocCode((UnsignedInt32)object);
                throw new PIHscServerException("150C", new String[]{string3}, null);
            }
        }
        if (n == 1 || n == 65 || n == 4) {
            if (unsignedInt32 != null && unsignedInt32.longValue() != 0L || unsignedInt322 != null && unsignedInt322.longValue() != 0L || unsignedInt323 != null && unsignedInt323.longValue() != 0L || unsignedInt324 != null && unsignedInt324.longValue() != 0L || unsignedInt325 != null && unsignedInt325.longValue() != 0L) {
                throw new PIHscServerException("07E5", null);
            }
        } else if (n == 129) {
            if (unsignedInt32 == null) {
                throw new PIHscServerException("0629", null);
            }
            if (vector5 == null) {
                throw new PIHscServerException("07E5", null);
            }
            if (!bl2) {
                Boolean bl3;
                Boolean bl4;
                Boolean bl5;
                Boolean bl6;
                Boolean bl7;
                n3 = 0;
                bl = false;
                if (vector5 != null && vector5.size() > 0 && (bl7 = (Boolean)vector5.elementAt(0)) != null && bl7.booleanValue()) {
                    bl = true;
                }
                if (!bl) {
                    if (object2 != null && (n2 = ((Vector)object2).indexOf(unsignedInt32)) != -1) {
                        object = "d";
                        if (vector2 != null && vector2.size() > n2) {
                            try {
                                object = (String)vector2.elementAt(n2);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        if (((String)object).equalsIgnoreCase("r")) {
                            n3 = 1;
                        }
                    }
                } else {
                    int n6;
                    Vector vector6 = new Vector();
                    try {
                        vector6 = (Vector)cIMInstance.getProperty("VirSCSIAdapters").getValue().getValue();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    object = new Vector();
                    try {
                        object = (Vector)cIMInstance.getProperty("VirSCSISlotReqDesAttribute").getValue().getValue();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (vector6 != null && vector6.size() > 0 && (n6 = vector6.indexOf(new UnsignedInt16(unsignedInt32.intValue()))) != -1 && object != null && ((Vector)object).size() > n6) {
                        string = "d";
                        try {
                            string = (String)((Vector)object).elementAt(n6);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (string != null && string.equalsIgnoreCase("r")) {
                            n3 = 1;
                        }
                    }
                }
                if (n3 == 0) {
                    throw new PIHscServerException("0628", null);
                }
                bl = false;
                if (vector5 != null && vector5.size() > 1 && (bl6 = (Boolean)vector5.elementAt(1)) != null && bl6.booleanValue()) {
                    bl = true;
                }
                if (bl) {
                    if (unsignedInt322 != null && unsignedInt322.longValue() >= 0L && unsignedInt322.longValue() >= (long)n4) {
                        throw new PIHscServerException("0627", null);
                    }
                } else if (unsignedInt322 != null && unsignedInt322.longValue() != 0L && !hashtable.containsKey(unsignedInt322) && !unsignedInt322.equals((Object)unsignedInt327)) {
                    throw new PIHscServerException("07E5", null);
                }
                bl = false;
                if (vector5 != null && vector5.size() > 2 && (bl5 = (Boolean)vector5.elementAt(2)) != null && bl5.booleanValue()) {
                    bl = true;
                }
                if (bl) {
                    if (unsignedInt323 != null && unsignedInt323.longValue() >= 0L && unsignedInt323.longValue() >= (long)n4) {
                        throw new PIHscServerException("0627", null);
                    }
                } else if (unsignedInt323 != null && unsignedInt323.longValue() != 0L && !hashtable.containsKey(unsignedInt323) && !unsignedInt323.equals((Object)unsignedInt328)) {
                    throw new PIHscServerException("07E5", null);
                }
                bl = false;
                if (vector5 != null && vector5.size() > 3 && (bl4 = (Boolean)vector5.elementAt(3)) != null && bl4.booleanValue()) {
                    bl = true;
                }
                if (bl) {
                    if (unsignedInt324 != null && unsignedInt324.longValue() >= 0L && unsignedInt324.longValue() >= (long)n4) {
                        throw new PIHscServerException("0627", null);
                    }
                } else if (unsignedInt324 != null && unsignedInt324.longValue() != 0L && !hashtable.containsKey(unsignedInt324) && !unsignedInt324.equals((Object)unsignedInt329)) {
                    throw new PIHscServerException("07E5", null);
                }
                bl = false;
                if (vector5 != null && vector5.size() > 4 && (bl3 = (Boolean)vector5.elementAt(4)) != null && bl3.booleanValue()) {
                    bl = true;
                }
                if (bl) {
                    if (unsignedInt325 != null && unsignedInt325.longValue() >= 0L && unsignedInt325.longValue() >= (long)n4) {
                        throw new PIHscServerException("0627", null);
                    }
                } else if (unsignedInt325 != null && unsignedInt325.longValue() != 0L && !hashtable.containsKey(unsignedInt325) && !unsignedInt325.equals((Object)unsignedInt3210)) {
                    throw new PIHscServerException("07E5", null);
                }
            } else {
                Boolean bl8;
                if (unsignedInt32 != null && unsignedInt32.longValue() != 0L && !hashtable.containsKey(unsignedInt32) && !unsignedInt32.equals((Object)unsignedInt326)) {
                    throw new PIHscServerException("0628", null);
                }
                if (unsignedInt322 != null && unsignedInt322.longValue() != 0L && !hashtable.containsKey(unsignedInt322) && !unsignedInt322.equals((Object)unsignedInt327)) {
                    throw new PIHscServerException("07E5", null);
                }
                n3 = 0;
                if (vector5 != null && vector5.size() > 2 && (bl8 = (Boolean)vector5.elementAt(2)) != null && bl8.booleanValue()) {
                    n3 = 1;
                }
                if (n3 != 0) {
                    if (unsignedInt323 != null && unsignedInt323.longValue() > 1L) {
                        throw new PIHscServerException("0627", null);
                    }
                } else if (unsignedInt323 != null && unsignedInt323.longValue() != 0L && !hashtable.containsKey(unsignedInt323) && !unsignedInt323.equals((Object)unsignedInt328)) {
                    throw new PIHscServerException("07E5", null);
                }
                if (unsignedInt324 != null && unsignedInt324.longValue() != 0L && !hashtable.containsKey(unsignedInt324) && !unsignedInt324.equals((Object)unsignedInt329)) {
                    throw new PIHscServerException("07E5", null);
                }
                if (unsignedInt325 != null && unsignedInt325.longValue() != 0L && !hashtable.containsKey(unsignedInt325) && !unsignedInt325.equals((Object)unsignedInt3210)) {
                    throw new PIHscServerException("07E5", null);
                }
            }
        }
        if (vector4 != null && vector4.size() > 0) {
            for (n3 = 0; n3 < vector4.size(); ++n3) {
                UnsignedInt16 unsignedInt162 = (UnsignedInt16)vector4.elementAt(n3);
                if (unsignedInt162.intValue() < n5) continue;
                throw new PIHscServerException("1468", null);
            }
        }
        Trace.trace("appphscT", "<- PILPARProfileInstProvUtils.checkIO");
    }

    public static void taggedIOCheck(int n, CIMInstance cIMInstance) throws PIHscServerException {
        UnsignedInt32 unsignedInt32 = null;
        try {
            unsignedInt32 = (UnsignedInt32)cIMInstance.getProperty("LoadSourceDRCIndex").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        UnsignedInt32 unsignedInt322 = null;
        try {
            unsignedInt322 = (UnsignedInt32)cIMInstance.getProperty("AltLoadSourceDRCIndex").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        UnsignedInt32 unsignedInt323 = null;
        try {
            unsignedInt323 = (UnsignedInt32)cIMInstance.getProperty("ConsoleDRCIndex").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        UnsignedInt32 unsignedInt324 = null;
        try {
            unsignedInt324 = (UnsignedInt32)cIMInstance.getProperty("AltConsoleDRCIndex").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        UnsignedInt32 unsignedInt325 = null;
        try {
            unsignedInt325 = (UnsignedInt32)cIMInstance.getProperty("ECSDRCIndex").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Vector vector = null;
        try {
            vector = (Vector)cIMInstance.getProperty("TaggedIOInfo").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (n == 1 || n == 65 || n == 4) {
            if (unsignedInt32 != null && unsignedInt32.longValue() != 0L || unsignedInt322 != null && unsignedInt322.longValue() != 0L || unsignedInt323 != null && unsignedInt323.longValue() != 0L || unsignedInt324 != null && unsignedInt324.longValue() != 0L || unsignedInt325 != null && unsignedInt325.longValue() != 0L) {
                throw new PIHscServerException("07E5", null);
            }
        } else if (n == 129) {
            if (unsignedInt32 == null) {
                throw new PIHscServerException("0629", null);
            }
            if (vector == null) {
                throw new PIHscServerException("07E5", null);
            }
        }
    }

    public static void normalLparMemChecks(int n, int n2, long l, CIMInstance cIMInstance, OmCecMgr omCecMgr) throws PIHscServerException {
        Trace.trace("appphscT", "PILPARProfileInstProvUtils.normalLparMemChecks ->");
        UnsignedInt32 unsignedInt32 = null;
        UnsignedInt32 unsignedInt322 = null;
        UnsignedInt32 unsignedInt323 = null;
        try {
            unsignedInt32 = (UnsignedInt32)cIMInstance.getProperty("MinimumMemory").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            unsignedInt322 = (UnsignedInt32)cIMInstance.getProperty("DesiredMemory").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            unsignedInt323 = (UnsignedInt32)cIMInstance.getProperty("MaximumMemory").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        PILPARProfileInstProvUtils.memValChecks(unsignedInt32.longValue(), unsignedInt322.longValue(), unsignedInt323.longValue(), n2, l, n, omCecMgr, false);
        Trace.trace("appphscT", "<- PILPARProfileInstProvUtils.normalLparMemChecks");
    }

    private static void reserveMemChecks(int n, int n2, long l, CIMInstance cIMInstance, OmCecMgr omCecMgr) throws PIHscServerException {
        Trace.trace("appphscT", "PILPARProfileInstProvUtils.reserveMemChecks ->");
        UnsignedInt32 unsignedInt32 = null;
        UnsignedInt32 unsignedInt322 = null;
        UnsignedInt32 unsignedInt323 = null;
        UnsignedInt32 unsignedInt324 = null;
        UnsignedInt32 unsignedInt325 = null;
        UnsignedInt32 unsignedInt326 = null;
        try {
            unsignedInt322 = (UnsignedInt32)cIMInstance.getProperty("Reserve1CurrMem").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            unsignedInt32 = (UnsignedInt32)cIMInstance.getProperty("Reserve1MinMem").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            unsignedInt323 = (UnsignedInt32)cIMInstance.getProperty("Reserve1MaxMem").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            unsignedInt325 = (UnsignedInt32)cIMInstance.getProperty("Reserve2CurrMem").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            unsignedInt324 = (UnsignedInt32)cIMInstance.getProperty("Reserve2MinMem").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            unsignedInt326 = (UnsignedInt32)cIMInstance.getProperty("Reserve2MaxMem").getValue().getValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (n == 1 || n == 65 || n == 129) {
            if (unsignedInt32 != null && unsignedInt32.longValue() != 0L || unsignedInt322 != null && unsignedInt322.longValue() != 0L || unsignedInt323 != null && unsignedInt323.longValue() != 0L || unsignedInt324 != null && unsignedInt324.longValue() != 0L || unsignedInt325 != null && unsignedInt325.longValue() != 0L || unsignedInt326 != null && unsignedInt326.longValue() != 0L) {
                throw new PIHscServerException("0617", null);
            }
        } else if (n == 4) {
            if (unsignedInt32 == null || unsignedInt322 == null || unsignedInt323 == null) {
                throw new PIHscServerException("07E6", null);
            }
            PILPARProfileInstProvUtils.memValChecks(unsignedInt32.longValue(), unsignedInt322.longValue(), unsignedInt323.longValue(), n2, l, n, omCecMgr, true);
            if (unsignedInt324 == null || unsignedInt325 == null || unsignedInt326 == null) {
                throw new PIHscServerException("07E7", null);
            }
            PILPARProfileInstProvUtils.memValChecks(unsignedInt324.longValue(), unsignedInt325.longValue(), unsignedInt326.longValue(), n2, l, n, omCecMgr, true);
        }
        Trace.trace("appphscT", "<- PILPARProfileInstProvUtils.reservedMemChecks");
    }

    public static void memValChecks(long l, long l2, long l3, int n, long l4, int n2, OmCecMgr omCecMgr, boolean bl) throws PIHscServerException {
        Trace.trace("appphscT", "PILPARProfileInstProvUtils.memValChecks ->");
        if (l % (long)n != 0L) {
            throw new PIHscServerException("0229", new String[]{String.valueOf(l), String.valueOf(n)}, null);
        }
        if (l2 % (long)n != 0L) {
            throw new PIHscServerException("0229", new String[]{String.valueOf(l2), String.valueOf(n)}, null);
        }
        if (l3 % (long)n != 0L) {
            throw new PIHscServerException("0229", new String[]{String.valueOf(l3), String.valueOf(n)}, null);
        }
        if (l < 0L || l > l2 || l2 > l3) {
            throw new PIHscServerException("0617", null);
        }
        if (!bl && l <= 0L) {
            throw new PIHscServerException("0617", null);
        }
        if (l3 > l4) {
            throw new PIHscServerException("03F9", null);
        }
        int n3 = 0;
        if (n2 == 1 || n2 == 65) {
            n3 = 1;
        } else if (n2 == 4) {
            n3 = 2;
        } else if (n2 == 129) {
            n3 = 3;
        }
        FspCmdHelper fspCmdHelper = omCecMgr.getCmdHelper();
        long l5 = 0L;
        try {
            FspRequiredMemoryInfo fspRequiredMemoryInfo = fspCmdHelper.getRequiredMinimumMemoryForMaximum(new UnsignedInt8((short)n3), omCecMgr.getRecommandedHptRatio(), new UnsignedInt32(l3 / (long)n));
            l5 = fspRequiredMemoryInfo.getReqMinMemRegionsAssignedToLpar().longValue() * (long)n;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (l5 > l) {
            throw new PIHscServerException("0618", new String[]{String.valueOf(l5)}, null);
        }
        Trace.trace("appphscT", "<- PILPARProfileInstProv.memValChecks");
    }

    public static void interactiveSettingCheck(int n, CIMInstance cIMInstance, OmCecMgr omCecMgr) throws PIHscServerException {
        Object object;
        Trace.trace("appphscT", "PILPARProfileInstProvUtils.interactiveSettingCheck ->");
        short s = ((UnsignedInt8)cIMInstance.getProperty("ProcMode").getValue().getValue()).shortValue();
        long l = 0L;
        l = s == 255 ? (long)(((UnsignedInt16)cIMInstance.getProperty("MaximumCPUCount").getValue().getValue()).intValue() * 100) : ((UnsignedInt32)cIMInstance.getProperty("MaxProcUnit").getValue().getValue()).longValue();
        UnsignedInt16 unsignedInt16 = null;
        UnsignedInt16 unsignedInt162 = null;
        UnsignedInt16 unsignedInt163 = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        try {
            unsignedInt16 = (UnsignedInt16)cIMInstance.getProperty("MinInteractivePerf").getValue().getValue();
            if (unsignedInt16 != null) {
                n2 = unsignedInt16.intValue();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            unsignedInt162 = (UnsignedInt16)cIMInstance.getProperty("DesiredInteractivePerf").getValue().getValue();
            if (unsignedInt162 != null) {
                n3 = unsignedInt162.intValue();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            unsignedInt163 = (UnsignedInt16)cIMInstance.getProperty("MaxInteractivePerf").getValue().getValue();
            if (unsignedInt163 != null) {
                n4 = unsignedInt163.intValue();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (unsignedInt16 == null && unsignedInt162 == null && unsignedInt163 == null) {
            return;
        }
        if (unsignedInt16 == null || unsignedInt162 == null || unsignedInt163 == null) {
            throw new PIHscServerException("07DE", null);
        }
        if (!(n != 1 && n != 65 && n != 4 || n2 == 0 && n3 == 0 && n4 == 0)) {
            System.out.println("minInteractiveVal = " + n2);
            System.out.println("desInteractiveVal = " + n3);
            System.out.println("maxInteractiveVal = " + n4);
            throw new PIHscServerException("07DE", null);
        }
        if (n2 > n3 || n3 > n4 || n2 < 0) {
            throw new PIHscServerException("07DE", null);
        }
        boolean bl = false;
        try {
            object = omCecMgr.getObject();
            bl = (Boolean)((RObject)object).getProperty("AllowHmcAssignInteractive");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!(bl || n2 == 0 && n3 == 0 && n4 == 0)) {
            throw new PIHscServerException("07DE", null);
        }
        object = omCecMgr.getCmdHelper();
        FspISeriesPerfRanges fspISeriesPerfRanges = null;
        try {
            fspISeriesPerfRanges = ((FspCmdHelper)object).getLparValidPerformanceRanges(new UnsignedInt32(l));
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            try {
                HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._LPARClassLogInfo);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        int n5 = 0;
        int n6 = 0;
        if (fspISeriesPerfRanges != null) {
            n5 = fspISeriesPerfRanges.getMinIntPerf().intValue();
            n6 = fspISeriesPerfRanges.getMaxIntPerf().intValue();
        }
        if (n2 < n5) {
            throw new PIHscServerException("03F8", new String[]{String.valueOf(n5)}, null);
        }
        if (n4 > n6) {
            throw new PIHscServerException("03F6", new String[]{String.valueOf(n6)}, null);
        }
        Trace.trace("appphscT", "<- PILPARProfileInstProvUtils.interactiveSettingCheck");
    }

    public static int extractOsType(OmLparMgr omLparMgr) {
        RObject rObject = omLparMgr.getObject();
        int n = 0;
        try {
            n = ((UnsignedInt8)rObject.getProperty("DefinitionState")).intValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        int n2 = 0;
        if (n == 1 || n == 2) {
            n2 = 1;
        } else if (n == 3 || n == 4) {
            n2 = 65;
        } else if (n == 65 || n == 66) {
            n2 = 4;
        } else if (n == 129 || n == 130) {
            n2 = 129;
        }
        return n2;
    }
}

